@extends('layouts.guest')

@section('content')
    <div class="container-xxl">
        <div class="authentication-wrapper authentication-basic container-p-y">
            <div class="authentication-inner">
                <!-- Register -->
                <div class="card">
                    <div class="card-body">
                        <!-- Logo -->
                        <div class="app-brand justify-content-center">
                            <a href="index.html" class="app-brand-link gap-2">
                                <span class="app-brand-logo demo">
                                    <img src="{{ asset('images/logo.png') }}" alt="" style="max-height: 50px;">
                                </span>
                            </a>
                        </div>
                        <!-- /Logo -->


                        <form method="POST" action="{{ route('login') }}">
                            @csrf
                            <div class="mb-3">
                                <label for="email" class="form-label">Email </label>
                                <input type="text" class="form-control" id="email" name="email"
                                    placeholder="Enter your email " autofocus required />
                                <div class="clearfix"></div>
                                @if ($errors->has('email'))
                                    <span class="form-text">
                                        <strong class="text-danger form-control-sm">{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="mb-3 form-password-toggle">
                                <div class="d-flex justify-content-between">
                                    <label class="form-label" for="password">Password</label>
                                </div>
                                <div class="input-group input-group-merge">
                                    <input type="password" id="password" class="form-control" name="password"
                                        placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                        aria-describedby="password" required />
                                    <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                    <div class="clearfix"></div>
                                    @if ($errors->has('password'))
                                        <span class="form-text">
                                            <strong
                                                class="text-danger form-control-sm">{{ $errors->first('password') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="mb-3">
                                <button class="btn btn-primary d-grid w-100" type="submit">Login</button>
                            </div>
                        </form>

                        {{-- <p class="text-center">
                            <span>New on our platform?</span>
                            <a href="{{ route('register') }}">
                                <span>Create an account</span>
                            </a>
                        </p> --}}
                    </div>
                </div>
                <!-- /Register -->
                
                
            </div>
            
            
        </div>
          
    </div>
<footer class="content-footer footer bg-footer-theme text-center">
    <div class="container-xxl py-2">
        ©
        <script>
            document.write(new Date().getFullYear());
        </script>
        , Developed By <a href="https://linkedin.com/in/humayunbee" target="_blank">Md. Humayun Farid</a> 
        ( Product By <a href="https://www.stitbd.com" target="_blank">STITBD</a>)
    </div>
</footer>

@endsection
